///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define AuthenticationString "trIeSPiUhouDlUwRLe5hie2H5awRoupiaDi8zI0fo3Y7u6R703r7e6rLacrouChi"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsValidCompanyPassword(int Client)
{
    char Statement[255];
    sprintf(Statement, "SELECT CompanyDatabase FROM Companys WHERE CompanyName = '%s' AND CompanyPassword = '%s'", CI[Client].CompanyName, CI[Client].CompanyPassword);

    HSTMT StatementHandle = NULL;

    if(!CI[Client].DBClass.DBExecute(Statement, &StatementHandle))
    {
        ErrorMessage(NULL, "DBexecute: IsValidCompanyPassword Fail.\n"); // FIXME: Need to log this error
        return false;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        CI[Client].DBClass.DBCloseCursor(&StatementHandle);
        ErrorMessage(NULL, "SQLRowCount: IsValidCompanyPassword Error.\n"); // FIXME: Need to log this error
        return false;
    }

    if(outRowCount != 1)
        return false;

    if(!CI[Client].DBClass.DBFetch(&StatementHandle))
    {
        ErrorMessage(NULL, "DBFetch error .\n"); // FIXME: Need to log this error
        CI[Client].DBClass.DBCloseCursor(&StatementHandle);
        return false;
    }

    SQLINTEGER DataLength = 0;
    SQLCHAR SQLBuffer[25 + 1];

    if(!CI[Client].DBClass.DBGetData(&StatementHandle, 1, SQL_C_CHAR, SQLBuffer, 25, &DataLength))
    {
        ErrorMessage(NULL, "DBGetData error .\n"); // FIXME: Need to log this error
        CI[Client].DBClass.DBCloseCursor(&StatementHandle);
        return false;
    }

    if(DataLength == -1)
	{
	    CI[Client].DBClass.DBCloseCursor(&StatementHandle);
		return false;
	}

    memcpy(CI[Client].CompanyDB, SQLBuffer, DataLength);

    CI[Client].DBClass.DBCloseCursor(&StatementHandle);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define CLIENTVER_ERROR     1
#define CLIENTVER_CURRENT   2
#define CLIENTVER_SUPPORTED 3
#define CLIENTVER_OUTDATED  4

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IsValidClientVersion(int Client)
{
    char Statement[255];
    sprintf(Statement, "SELECT Status FROM ClientVersions WHERE Version = '%s'", CI[Client].ClientVersion);

    HSTMT StatementHandle = NULL;

    if(!CI[Client].DBClass.DBExecute(Statement, &StatementHandle))
    {
        ErrorMessage(NULL, "DBexecute: IsValidClientVersion Fail.\n"); // FIXME: Need to log this error
        return CLIENTVER_ERROR;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        CI[Client].DBClass.DBCloseCursor(&StatementHandle);
        ErrorMessage(NULL, "SQLRowCount: IsValidClientVersion Error.\n"); // FIXME: Need to log this error
        return CLIENTVER_ERROR;
    }

    if(outRowCount == 0)
    {
        ErrorMessage(NULL, "Unknown client version .\n"); // FIXME: Need to log this error
        CI[Client].DBClass.DBCloseCursor(&StatementHandle);
        return CLIENTVER_ERROR;
    }

    if(!CI[Client].DBClass.DBFetch(&StatementHandle))
    {
        ErrorMessage(NULL, "DBFetch error .\n"); // FIXME: Need to log this error
        CI[Client].DBClass.DBCloseCursor(&StatementHandle);
        return CLIENTVER_ERROR;
    }

    SQLINTEGER DataLength = 0;
    SQLCHAR SQLBuffer[10 + 1];

    if(!CI[Client].DBClass.DBGetData(&StatementHandle, 1, SQL_C_CHAR, SQLBuffer, 10, &DataLength))
    {
        ErrorMessage(NULL, "DBGetData error .\n"); // FIXME: Need to log this error
        CI[Client].DBClass.DBCloseCursor(&StatementHandle);
        return CLIENTVER_ERROR;
    }

    CI[Client].DBClass.DBCloseCursor(&StatementHandle);

    SQLBuffer[DataLength] = '\0';

    if(strcmpi((char *)SQLBuffer, "current") == 0){ // Current version
        return CLIENTVER_CURRENT;
    }
    else if(strcmpi((char *)SQLBuffer, "supported") == 0){ // Old but supported
        return CLIENTVER_SUPPORTED;
    }
    else if(strcmpi((char *)SQLBuffer, "outdated") == 0){ // Old and nolonger supported
        return CLIENTVER_OUTDATED;
    }
    else{
        ErrorMessage(NULL, "Unknown version identifier .\n"); // FIXME: Need to log this error
        return CLIENTVER_ERROR;
    }

    return CLIENTVER_ERROR;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AuthProcessCommand(int Client, char *ReceivedData, int ReceivedSize)
{
    int FlagLength = 0;
    int FlaggedLength = 0;
    char FlaggedData[MaxReceiveSize + 1];
	//char SendTemp[MaxReceiveSize + 1];

    if((FlagLength = CompareFlagedString(ReceivedData, "::Authentication:")))
    {
        if(ReceivedSize - FlagLength > MaxReceiveSize || ReceivedSize - FlagLength < 8)
        {
            SimpleServerSend(Client, "::Error:Fatal error accepting authentication.");
            return AUTH_CMD_DISCONNECT;
        }

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        if( strcmp(AuthenticationString, FlaggedData) == 0)
        {
            CI[Client].Authenticated = true;
            SimpleServerSend(Client, "::ReqCompanyName");
    		return AUTH_CMD_OK;
        }

        SimpleServerSend(Client, "::Error:Pre-connect authentication failed.");
        return AUTH_CMD_FAILED;
    }
    else if( strcmp(ReceivedData, "Request.Disconnect") == 0)
    {
        return AUTH_CMD_DISCONNECT;
    }
    else if(CI[Client].Authenticated == false)
    {
        WriteLog("Unauthorized command.");
        return AUTH_CMD_FAILED;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::CompanyName:")))
    {
        if(ReceivedSize - FlagLength > 64 || ReceivedSize - FlagLength < 1)
        {
            SimpleServerSend(Client, "::Error:Fatal error accepting CompanyName.");
            return AUTH_CMD_DISCONNECT;
        }

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        strcpy(CI[Client].CompanyName, FlaggedData);
        SimpleServerSend(Client, "::ReqCompanyPassword");

        return AUTH_CMD_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::CompanyPassword:")))
    {
        if(ReceivedSize - FlagLength > 64 || ReceivedSize - FlagLength < 1)
        {
            SimpleServerSend(Client, "::Error:Fatal error accepting CompanyPassword.");
            return AUTH_CMD_DISCONNECT;
        }

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        strcpy(CI[Client].CompanyPassword, FlaggedData);

        if(IsValidCompanyPassword(Client))
        {
            SimpleServerSend(Client, "::ReqClientVersion");
            return AUTH_CMD_OK;
        }

        SimpleServerSend(Client, "::Error:Invalid company account.");
        return AUTH_CMD_FAILED;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::ClientVersion:")))
    {
        if(ReceivedSize - FlagLength > 64 || ReceivedSize - FlagLength < 1)
        {
            SimpleServerSend(Client, "::Error:Fatal error accepting ClientVersion.");
            return AUTH_CMD_DISCONNECT;
        }

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        strcpy(CI[Client].ClientVersion, FlaggedData);

        int CVResult = IsValidClientVersion(Client);
        if(CVResult == CLIENTVER_CURRENT){
            SimpleServerSend(Client, "::Authentication.Success");
            return AUTH_CMD_SUCCESS;
        }
        else if(CVResult == CLIENTVER_SUPPORTED){
            SimpleServerSend(Client, "::Message:Client software is outdated but still supported. Update soon!");
            return AUTH_CMD_OK;
        }
        else if(CVResult == CLIENTVER_OUTDATED){
            SimpleServerSend(Client, "::Error:Client software version is nolonger supported. Update now!");
            return AUTH_CMD_DISCONNECT;
        }
        else{
            SimpleServerSend(Client, "::Error:Error verifing client version. Update now!");
            return AUTH_CMD_DISCONNECT;
        }

        SimpleServerSend(Client, "::Error:Error verifing client version. Update now!");
        return AUTH_CMD_FAILED;
    }

    return AUTH_CMD_UNKNOWN;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AuthenticateClient(int Client)
{
    char ReceiveData[MaxReceiveSize];
    int ReceiveSize = 0;

    while(MyServer.Connected[Client])
    {
        if(MyServer.GetReceiveData(Client, ReceiveData, &ReceiveSize) )
        {
            ReceiveData[ReceiveSize] = '\0';

            int AuthCmdResult = AuthProcessCommand(Client, ReceiveData, ReceiveSize);

            if(AuthCmdResult == AUTH_CMD_FAILED)
            {
//                WriteLog("AuthCmdResult AUTH_CMD_FAILED.");
                Sleep(100);
                return AUTH_CMD_FAILED;
            }
            else if(AuthCmdResult == AUTH_CMD_UNKNOWN){
//                WriteLog("AuthCmdResult AUTH_CMD_UNKNOWN.");
                Sleep(100);
                return AUTH_CMD_UNKNOWN;
            }
            else if(AuthCmdResult == AUTH_CMD_DISCONNECT){
//                WriteLog("AuthCmdResult AUTH_CMD_SUCCESS.");
                Sleep(100);
                return AUTH_CMD_DISCONNECT;
            }
            else if(AuthCmdResult == AUTH_CMD_SUCCESS){
//                WriteLog("AuthCmdResult AUTH_CMD_SUCCESS.");
                Sleep(100);
                return AUTH_CMD_SUCCESS;
            }
            else if(AuthCmdResult == AUTH_CMD_OK){
//                WriteLog("AuthCmdResult AUTH_CMD_OK.");
                Sleep(100);
                // Still authenticating
            }
        }
        else Sleep(1);

        Sleep(1);
    }

//    WriteLog("AuthCmdResult DISCONNECTED.");
    return AUTH_CMD_DISCONNECT;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

